import { Module } from '@nestjs/common';
import { SmsController } from './sms.controller';
import { SmsService } from './sms.service';
import { TwilioProvider } from './providers/twilio.provider';
import { PlivoProvider } from './providers/plivo.provider';
import { InfobipProvider } from './providers/infobip.provider';
import { AfricasTalkingProvider } from './providers/africastalking.provider';
import { SmsProviderFactory } from './providers/provider.factory';
import { PrismaModule } from '../../common/prisma/prisma.module';

@Module({
  imports: [PrismaModule],
  controllers: [SmsController],
  providers: [
    SmsService,
    SmsProviderFactory,
    TwilioProvider,
    PlivoProvider,
    InfobipProvider,
    AfricasTalkingProvider,
  ],
  exports: [SmsService, SmsProviderFactory],
})
export class SmsModule {}
