import { Module } from '@nestjs/common';
import { ReferralController } from './referral.controller';
import { ReferralService } from './referral.service';
import { RewardsService } from './rewards.service';
import { PrismaModule } from '../../common/prisma/prisma.module';
import { NotificationModule } from '../notification/notification.module';

@Module({
  imports: [PrismaModule, NotificationModule],
  controllers: [ReferralController],
  providers: [ReferralService, RewardsService],
  exports: [ReferralService, RewardsService],
})
export class ReferralModule {}
