import { IsString, MaxLength, MinLength } from 'class-validator';
import { ApiProperty } from '@nestjs/swagger';

export class ApplyReferralDto {
  @ApiProperty({ description: 'Referral code to apply', example: 'ABCD1234' })
  @IsString()
  @MinLength(6)
  @MaxLength(20)
  code: string;
}
