import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { IsNumber, IsString, IsOptional, Min } from 'class-validator';

export class AddWalletFundsDto {
  @ApiProperty({ example: 5000, description: 'Amount to add' })
  @IsNumber()
  @Min(100)
  amount: number;

  @ApiProperty({ example: 'card', description: 'Payment method for top-up' })
  @IsString()
  payment_method: string;

  @ApiPropertyOptional({ example: 'tok_visa', description: 'Payment token' })
  @IsOptional()
  @IsString()
  token?: string;
}
