import { Module } from '@nestjs/common';
import { TerminusModule } from '@nestjs/terminus';
import { HttpModule } from '@nestjs/axios';
import { HealthController } from './health.controller';
import { HealthService } from './health.service';
import { DatabaseHealthIndicator } from './indicators/database.indicator';
import { RedisHealthIndicator } from './indicators/redis.indicator';
import { StorageHealthIndicator } from './indicators/storage.indicator';
import { ExternalServicesHealthIndicator } from './indicators/external-services.indicator';
import { PrismaModule } from '../../common/prisma/prisma.module';

@Module({
  imports: [
    TerminusModule,
    HttpModule,
    PrismaModule,
  ],
  controllers: [HealthController],
  providers: [
    HealthService,
    DatabaseHealthIndicator,
    RedisHealthIndicator,
    StorageHealthIndicator,
    ExternalServicesHealthIndicator,
  ],
  exports: [HealthService],
})
export class HealthModule {}
