import { Module } from '@nestjs/common';
import { HandymanController } from './handyman.controller';
import { HandymanService } from './handyman.service';
import { PrismaModule } from '../../common/prisma/prisma.module';
import { NotificationModule } from '../notification/notification.module';
import { QueueModule } from '../queue/queue.module';

@Module({
  imports: [PrismaModule, NotificationModule, QueueModule],
  controllers: [HandymanController],
  providers: [HandymanService],
  exports: [HandymanService],
})
export class HandymanModule {}
