import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { IsNumber, IsOptional } from 'class-validator';

export class UpdateLocationDto {
  @ApiProperty({ example: 6.1725 })
  @IsNumber()
  latitude: number;

  @ApiProperty({ example: 1.2314 })
  @IsNumber()
  longitude: number;

  @ApiPropertyOptional({ example: 45.5, description: 'Heading in degrees (0-360)' })
  @IsOptional()
  @IsNumber()
  heading?: number;

  @ApiPropertyOptional({ example: 30.5, description: 'Speed in km/h' })
  @IsOptional()
  @IsNumber()
  speed?: number;
}
