import { IsString, IsOptional, MaxLength } from 'class-validator';
import { ApiPropertyOptional } from '@nestjs/swagger';

export class CompleteDeliveryDto {
  @ApiPropertyOptional({ description: 'Photo proof of delivery' })
  @IsOptional()
  @IsString()
  deliveryProofImage?: string;

  @ApiPropertyOptional({ description: 'Recipient signature (base64)' })
  @IsOptional()
  @IsString()
  recipientSignature?: string;

  @ApiPropertyOptional({ description: 'Recipient name' })
  @IsOptional()
  @IsString()
  @MaxLength(100)
  recipientName?: string;
}
