import { Module } from '@nestjs/common';
import { ScheduleModule } from '@nestjs/schedule';
import { CronController } from './cron.controller';
import { CronService } from './cron.service';
import { BookingTasksService } from './tasks/booking.tasks';
import { DriverTasksService } from './tasks/driver.tasks';
import { PaymentTasksService } from './tasks/payment.tasks';
import { NotificationTasksService } from './tasks/notification.tasks';
import { CleanupTasksService } from './tasks/cleanup.tasks';
import { ReportTasksService } from './tasks/report.tasks';
import { PrismaModule } from '../../common/prisma/prisma.module';
import { NotificationModule } from '../notification/notification.module';
import { SmsModule } from '../sms/sms.module';

@Module({
  imports: [
    ScheduleModule.forRoot(),
    PrismaModule,
    NotificationModule,
    SmsModule,
  ],
  controllers: [CronController],
  providers: [
    CronService,
    BookingTasksService,
    DriverTasksService,
    PaymentTasksService,
    NotificationTasksService,
    CleanupTasksService,
    ReportTasksService,
  ],
  exports: [CronService],
})
export class CronModule {}
