import { ApiProperty } from '@nestjs/swagger';
import { IsString, MinLength, Length } from 'class-validator';

export class ResetPasswordDto {
  @ApiProperty({ example: 'john@example.com', description: 'Email or phone number' })
  @IsString()
  email_or_phone: string;

  @ApiProperty({ example: '123456', description: '6-digit OTP code' })
  @IsString()
  @Length(6, 6)
  otp: string;

  @ApiProperty({ example: 'newpassword123' })
  @IsString()
  @MinLength(6)
  new_password: string;
}
