import { Module } from '@nestjs/common';
import { AdminController } from './admin.controller';
import { AdminService } from './admin.service';
import { DashboardService } from './dashboard.service';
import { ReportsService } from './reports.service';
import { PrismaModule } from '../../common/prisma/prisma.module';
import { NotificationModule } from '../notification/notification.module';

@Module({
  imports: [PrismaModule, NotificationModule],
  controllers: [AdminController],
  providers: [AdminService, DashboardService, ReportsService],
  exports: [AdminService, DashboardService, ReportsService],
})
export class AdminModule {}
