-- Table: surge_configs
-- Configuration for surge pricing per zone and vehicle type

CREATE TABLE `surge_configs` (
  `id` bigint UNSIGNED NOT NULL,
  `surge_zone_id` bigint UNSIGNED NOT NULL,
  `vehicle_type_id` int UNSIGNED DEFAULT NULL,
  `base_multiplier` decimal(4,2) NOT NULL DEFAULT '1.00',
  `max_multiplier` decimal(4,2) NOT NULL DEFAULT '3.00',
  `min_multiplier` decimal(4,2) NOT NULL DEFAULT '1.00',
  `min_drivers_threshold` int NOT NULL DEFAULT '3',
  `high_demand_requests` int NOT NULL DEFAULT '5',
  `demand_window_minutes` int NOT NULL DEFAULT '5',
  `increment_step` decimal(4,2) NOT NULL DEFAULT '0.25',
  `auto_surge` tinyint(1) NOT NULL DEFAULT '1',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Primary key and indexes would be added via ALTER TABLE statements
