-- Table: driver_levels
-- Driver loyalty/tier levels with benefits and requirements

CREATE TABLE `driver_levels` (
  `id` bigint UNSIGNED NOT NULL,
  `merchant_id` int UNSIGNED NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `slug` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `color` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#CD7F32',
  `icon` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `min_points` int NOT NULL DEFAULT '0',
  `min_rides` int NOT NULL DEFAULT '0',
  `min_days_active` int NOT NULL DEFAULT '0',
  `min_acceptance_rate` decimal(5,2) NOT NULL DEFAULT '0.00',
  `max_cancellation_rate` decimal(5,2) NOT NULL DEFAULT '100.00',
  `min_rating` decimal(3,2) NOT NULL DEFAULT '0.00',
  `bonus_multiplier` decimal(5,2) NOT NULL DEFAULT '1.00',
  `commission_rate` decimal(5,2) NOT NULL DEFAULT '15.00',
  `points_per_ride` decimal(5,2) NOT NULL DEFAULT '10.00',
  `priority_rides` tinyint(1) NOT NULL DEFAULT '0',
  `priority_rides_bonus` int UNSIGNED NOT NULL DEFAULT '100' COMMENT 'Bonus de points au dispatch quand priority_rides est active',
  `priority_support` tinyint(1) NOT NULL DEFAULT '0',
  `premium_zones_access` tinyint(1) NOT NULL DEFAULT '0',
  `exclusive_quests` tinyint(1) NOT NULL DEFAULT '0',
  `guaranteed_minimum` tinyint(1) NOT NULL DEFAULT '0',
  `benefits` json DEFAULT NULL,
  `sort_order` int NOT NULL DEFAULT '0',
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Primary key and indexes would be added via ALTER TABLE statements
