CREATE TABLE `bookings` (
  `id` int UNSIGNED NOT NULL,
  `merchant_id` int UNSIGNED DEFAULT NULL,
  `segment_id` int UNSIGNED DEFAULT NULL,
  `merchant_booking_id` int DEFAULT NULL,
  `corporate_id` int UNSIGNED DEFAULT NULL,
  `taxi_company_id` int UNSIGNED DEFAULT NULL,
  `booking_status` int NOT NULL DEFAULT '1001',
  `booking_status_history` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `pause_resume_history` json DEFAULT NULL COMMENT 'Historique JSON des événements pause/reprise avec positions GPS',
  `hotel_id` int UNSIGNED DEFAULT NULL,
  `franchise_id` int UNSIGNED DEFAULT NULL,
  `platform` int NOT NULL DEFAULT '1' COMMENT '1 : User App 2 : Admin Panel 3 : WhatsApp',
  `user_id` int UNSIGNED DEFAULT NULL,
  `client_phone` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Numéro du client pour courses manuelles (sans créer de User)',
  `client_name` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Nom du client pour courses manuelles',
  `driver_id` int UNSIGNED DEFAULT NULL,
  `driver_accepted_at` timestamp NULL DEFAULT NULL,
  `is_reassigned` tinyint(1) DEFAULT '0',
  `reassigned_at` timestamp NULL DEFAULT NULL,
  `assigned_at` timestamp NULL DEFAULT NULL,
  `assigned_by_admin` tinyint(1) NOT NULL DEFAULT '0',
  `country_area_id` int UNSIGNED DEFAULT NULL,
  `service_type_id` int UNSIGNED DEFAULT NULL,
  `vehicle_type_id` int UNSIGNED DEFAULT NULL,
  `service_package_id` int DEFAULT NULL,
  `is_geofence` int NOT NULL DEFAULT '0' COMMENT '0 - Normal booking, 1 - Geofence booking',
  `base_area_id` int UNSIGNED DEFAULT NULL,
  `auto_upgradetion` int NOT NULL DEFAULT '2',
  `upgrade_response` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Réponse du client à la proposition d'upgrade',
  `number_of_rider` int DEFAULT '1',
  `total_drop_location` int NOT NULL DEFAULT '0',
  `price_card_id` int UNSIGNED DEFAULT NULL,
  `price_card_details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `driver_vehicle_id` int DEFAULT NULL,
  `family_member_id` int UNSIGNED DEFAULT NULL,
  `pickup_latitude` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pickup_longitude` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `pickup_location` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `drop_latitude` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `drop_longitude` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `drop_location` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `waypoints` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `payment_status` int DEFAULT '0',
  `cancel_reason_id` int UNSIGNED DEFAULT NULL,
  `booking_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_manual_booking` tinyint(1) NOT NULL DEFAULT '0',
  `map_image` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `ploy_points` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `estimate_bill` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '0.00',
  `notificationID` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estimate_distance` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `travel_distance` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `estimate_time` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `travel_time` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `travel_time_min` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `discounted_amout` decimal(10,0) DEFAULT NULL,
  `estimate_driver_distnace` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `estimate_driver_time` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_method_id` int UNSIGNED DEFAULT NULL,
  `card_id` int UNSIGNED DEFAULT NULL,
  `promo_code` int UNSIGNED DEFAULT NULL,
  `final_amount_paid` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.00',
  `company_cut` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `driver_cut` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hotel_charges` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `additional_notes` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `additional_information` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `additional_movers` int DEFAULT NULL,
  `receiver_details` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `booking_timestamp` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `unique_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `booking_closure` int DEFAULT NULL,
  `later_booking_date` date DEFAULT NULL,
  `later_booking_time` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `return_date` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `return_time` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ride_otp` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ride_otp_verify` int DEFAULT NULL,
  `baby_seat_enable` int DEFAULT NULL,
  `wheel_chair_enable` int DEFAULT NULL,
  `ac_nonac` int DEFAULT NULL,
  `no_of_person` int DEFAULT NULL,
  `no_of_children` int DEFAULT NULL,
  `no_of_bags` int DEFAULT NULL,
  `bags_weight_kg` int DEFAULT NULL,
  `manual_dispatch_ride` int DEFAULT NULL,
  `gender` int DEFAULT NULL,
  `insurnce` int DEFAULT NULL,
  `bill_details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `estimate_receipt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `settlement` varchar(11) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ride_radius` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `onride_pause_timestamp` datetime DEFAULT NULL,
  `onride_resume_timestamp` datetime DEFAULT NULL,
  `onride_waiting_type` tinyint NOT NULL DEFAULT '0' COMMENT '0 - No Action, 1 - Pause, 2 - Resume',
  `onride_waiting_time` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price_for_ride` int DEFAULT NULL,
  `price_for_ride_amount` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `arrived_at` timestamp NULL DEFAULT NULL,
  `search_started_at` timestamp NULL DEFAULT NULL,
  `driver_assigned_at` timestamp NULL DEFAULT NULL,
  `search_duration_sec` int DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `user_masked_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `driver_masked_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `session_sid` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `end_map_image` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `majoration` double DEFAULT NULL,
  `cancelled_at` timestamp NULL DEFAULT NULL,
  `distance` double DEFAULT NULL,
  `old_travel_time_min` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `old_travel_distance` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bonus_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin,
  `commission` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_edit_in_process` tinyint(1) DEFAULT NULL COMMENT 'Help when invoice edit process stop, not successfull',
  `invoice_edited_at` timestamp NULL DEFAULT NULL,
  `amount_cash_collected` double DEFAULT NULL COMMENT 'Cash amount that driver collected from user when invoice issue',
  `invoice_edit_payment_method_id` int DEFAULT NULL,
  `fav_driver_id` int UNSIGNED DEFAULT NULL,
  `latitude` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `longitude` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `checkout` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `area` int NOT NULL,
  `service_type` int NOT NULL,
  `pick_up_locaion` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fornew` int NOT NULL DEFAULT '1',
  `vehicle_type` int NOT NULL,
  `checkout_id` int UNSIGNED DEFAULT NULL,
  `delete_status` int NOT NULL DEFAULT '1',
  `last_latitude` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_longitude` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_update_time` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `free_waiting_time_enable` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `waiting_fee_enable` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `free_waiting_time` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `onride_ac_timestamp` datetime DEFAULT NULL,
  `onride_ac_type` tinyint NOT NULL DEFAULT '0',
  `onride_ac_time` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `onride_ac_latitude` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `onride_ac_longitude` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `onride_ac_distance` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `waiting_fee` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `currency` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vehicle_number_plate_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `share_able_link` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `otp_enable` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `driver_full_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `cancelable` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `distance_traveled` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time_elapsed` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `distance_google_directions` double(10,2) DEFAULT NULL COMMENT 'Distance calculée via Google Directions API',
  `distance_google_directions_noopt` double(10,2) DEFAULT NULL COMMENT 'Distance Google Directions non-optimisée',
  `distance_google_matrix` double(10,2) DEFAULT NULL COMMENT 'Distance via Google Matrix API',
  `distance_waypoints` double(10,2) DEFAULT NULL COMMENT 'Distance calculée via waypoints',
  `distance_haversine` double(10,2) DEFAULT NULL COMMENT 'Distance Haversine directe',
  `distance_time_based` double(10,2) DEFAULT NULL COMMENT 'Distance estimée basée sur le temps',
  `distance_round_trip` double(10,2) DEFAULT NULL COMMENT 'Distance spécifique aller-retour',
  `distance_app_reported` double(10,2) DEFAULT NULL COMMENT 'Distance rapportée par l''application',
  `distance_final` double(10,2) DEFAULT NULL COMMENT 'Distance finale retenue',
  `distance_calculation_method` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'Méthode de calcul utilisée',
  `is_round_trip` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Indique si c''est un aller-retour',
  `distance_calculated_at` timestamp NULL DEFAULT NULL COMMENT 'Date du calcul de distance'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
