-- Table: booking_request_drivers
-- Tracks booking requests sent to drivers with response times and scoring

CREATE TABLE `booking_request_drivers` (
  `id` int UNSIGNED NOT NULL,
  `booking_id` int UNSIGNED DEFAULT NULL,
  `requested_at` timestamp NULL DEFAULT NULL,
  `responded_at` timestamp NULL DEFAULT NULL,
  `response_time_sec` int DEFAULT NULL,
  `order_id` int UNSIGNED DEFAULT NULL,
  `handyman_order_id` int UNSIGNED DEFAULT NULL,
  `driver_id` int UNSIGNED DEFAULT NULL,
  `vehicle_type_id` bigint UNSIGNED DEFAULT NULL,
  `distance_from_pickup` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `score` decimal(5,2) DEFAULT NULL,
  `radius_sent` decimal(5,2) DEFAULT NULL,
  `is_priority_offer` tinyint(1) NOT NULL DEFAULT '0',
  `offered_at` timestamp NULL DEFAULT NULL,
  `scoring_details` json DEFAULT NULL,
  `request_status` int NOT NULL DEFAULT '1' COMMENT '1 Sending request in process, 2 Accepted, 3 Rejected, 4 Cancelled',
  `inside_function` int DEFAULT NULL,
  `attempt` int NOT NULL DEFAULT '0',
  `cancellation_reason_id` int UNSIGNED DEFAULT NULL,
  `cancelled_after_acceptance_at` timestamp NULL DEFAULT NULL,
  `delete_status` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Primary key and indexes would be added via ALTER TABLE statements
