# API Reference MonkAPI

## Vue d'ensemble

L'API MonkAPI est RESTful et utilise JSON pour les requetes et reponses.

- **Base URL**: `https://api.monkapi.com/api/v1`
- **Format**: JSON
- **Authentification**: Bearer Token (JWT)

## Authentification

Toutes les requetes (sauf celles marquees publiques) necessitent un token JWT.

```http
Authorization: Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...
```

### Headers requis

| Header | Description | Exemple |
|--------|-------------|---------|
| `Authorization` | Token JWT | `Bearer xxx` |
| `X-Merchant-Id` | ID du merchant | `1` |
| `Content-Type` | Type de contenu | `application/json` |
| `Accept` | Format accepte | `application/json` |

## Format des reponses

### Succes

```json
{
  "version": "1.0",
  "result": "1",
  "message": "Success",
  "data": { ... }
}
```

### Erreur

```json
{
  "version": "1.0",
  "result": "0",
  "message": "Error message",
  "error_code": "BOOKING_NOT_FOUND",
  "details": { ... }
}
```

### Pagination

```json
{
  "version": "1.0",
  "result": "1",
  "message": "Success",
  "data": [...],
  "meta": {
    "total": 100,
    "page": 1,
    "limit": 20,
    "totalPages": 5
  }
}
```

---

## Authentication

### POST /auth/signup

Inscription d'un nouvel utilisateur.

**Request:**

```json
{
  "first_name": "John",
  "last_name": "Doe",
  "email": "john@example.com",
  "phone": "+22890123456",
  "country_code": "+228",
  "password": "SecurePass123!",
  "device_type": "android",
  "fcm_token": "xxx",
  "referral_code": "ABC123"
}
```

**Response (201):**

```json
{
  "version": "1.0",
  "result": "1",
  "message": "Inscription reussie",
  "data": {
    "user": {
      "id": 1,
      "first_name": "John",
      "last_name": "Doe",
      "email": "john@example.com",
      "phone": "+22890123456",
      "referral_code": "JOH456"
    },
    "access_token": "eyJ...",
    "refresh_token": "eyJ...",
    "expires_in": 604800
  }
}
```

### POST /auth/login

Connexion utilisateur.

**Request:**

```json
{
  "email": "john@example.com",
  "password": "SecurePass123!",
  "device_type": "android",
  "fcm_token": "xxx"
}
```

**Response (200):**

```json
{
  "version": "1.0",
  "result": "1",
  "message": "Connexion reussie",
  "data": {
    "user": { ... },
    "access_token": "eyJ...",
    "refresh_token": "eyJ...",
    "expires_in": 604800
  }
}
```

### POST /auth/login-otp

Connexion par OTP (SMS).

**Request:**

```json
{
  "phone": "+22890123456",
  "country_code": "+228"
}
```

**Response (200):**

```json
{
  "version": "1.0",
  "result": "1",
  "message": "OTP envoye",
  "data": {
    "otp_sent": true,
    "expires_in": 300
  }
}
```

### POST /auth/verify-otp

Verification OTP.

**Request:**

```json
{
  "phone": "+22890123456",
  "otp": "123456"
}
```

**Response (200):**

```json
{
  "version": "1.0",
  "result": "1",
  "message": "OTP verifie",
  "data": {
    "user": { ... },
    "access_token": "eyJ...",
    "refresh_token": "eyJ..."
  }
}
```

### POST /auth/refresh

Rafraichir le token d'acces.

**Request:**

```json
{
  "refresh_token": "eyJ..."
}
```

**Response (200):**

```json
{
  "version": "1.0",
  "result": "1",
  "message": "Token rafraichi",
  "data": {
    "access_token": "eyJ...",
    "expires_in": 604800
  }
}
```

### POST /auth/forgot-password

Demande de reinitialisation mot de passe.

**Request:**

```json
{
  "email": "john@example.com"
}
```

### POST /auth/logout

Deconnexion (invalide les tokens).

**Response (200):**

```json
{
  "version": "1.0",
  "result": "1",
  "message": "Deconnexion reussie"
}
```

---

## User

### GET /user/profile

Obtenir le profil utilisateur.

**Response (200):**

```json
{
  "version": "1.0",
  "result": "1",
  "data": {
    "id": 1,
    "first_name": "John",
    "last_name": "Doe",
    "email": "john@example.com",
    "phone": "+22890123456",
    "profile_image": "https://s3.../avatar.jpg",
    "wallet_balance": 15000,
    "rating": 4.8,
    "total_rides": 42,
    "referral_code": "JOH456",
    "created_at": "2024-01-15T10:30:00Z"
  }
}
```

### PUT /user/profile

Mettre a jour le profil.

**Request:**

```json
{
  "first_name": "John",
  "last_name": "Smith",
  "email": "john.smith@example.com"
}
```

### POST /user/profile/image

Upload image de profil.

**Request (multipart/form-data):**

```
image: [file]
```

### GET /user/wallet

Obtenir le solde du portefeuille.

**Response (200):**

```json
{
  "data": {
    "balance": 15000,
    "currency": "XOF",
    "pending": 0,
    "transactions": [
      {
        "id": 1,
        "type": "credit",
        "amount": 5000,
        "description": "Recharge",
        "created_at": "2024-01-20T15:00:00Z"
      }
    ]
  }
}
```

### POST /user/wallet/topup

Recharger le portefeuille.

**Request:**

```json
{
  "amount": 10000,
  "payment_method_id": 1
}
```

---

## Booking

### POST /booking/estimate

Obtenir une estimation de course.

**Request:**

```json
{
  "pickup_latitude": 6.1319,
  "pickup_longitude": 1.2228,
  "pickup_address": "123 Rue de Lome",
  "drop_latitude": 6.1725,
  "drop_longitude": 1.2314,
  "drop_address": "456 Avenue Liberation",
  "vehicle_type_id": 1
}
```

**Response (200):**

```json
{
  "data": {
    "distance": 8.5,
    "duration": 25,
    "estimates": [
      {
        "vehicle_type_id": 1,
        "vehicle_name": "Standard",
        "estimated_fare": 3500,
        "surge_multiplier": 1.0,
        "eta": 5
      },
      {
        "vehicle_type_id": 2,
        "vehicle_name": "Comfort",
        "estimated_fare": 5000,
        "surge_multiplier": 1.0,
        "eta": 3
      }
    ],
    "currency": "XOF"
  }
}
```

### POST /booking/create

Creer une reservation.

**Request:**

```json
{
  "pickup_latitude": 6.1319,
  "pickup_longitude": 1.2228,
  "pickup_address": "123 Rue de Lome",
  "drop_latitude": 6.1725,
  "drop_longitude": 1.2314,
  "drop_address": "456 Avenue Liberation",
  "vehicle_type_id": 1,
  "payment_method": "cash",
  "promo_code": "WELCOME10",
  "notes": "Portail bleu"
}
```

**Response (201):**

```json
{
  "data": {
    "id": 123,
    "booking_number": "BK-2024-00123",
    "booking_status": "pending",
    "pickup_address": "123 Rue de Lome",
    "drop_address": "456 Avenue Liberation",
    "estimated_fare": 3150,
    "discount_amount": 350,
    "payment_method": "cash",
    "created_at": "2024-01-20T16:30:00Z"
  }
}
```

### GET /booking/:id

Obtenir les details d'une reservation.

**Response (200):**

```json
{
  "data": {
    "id": 123,
    "booking_number": "BK-2024-00123",
    "booking_status": "accepted",
    "pickup_latitude": 6.1319,
    "pickup_longitude": 1.2228,
    "pickup_address": "123 Rue de Lome",
    "drop_latitude": 6.1725,
    "drop_longitude": 1.2314,
    "drop_address": "456 Avenue Liberation",
    "estimated_fare": 3150,
    "final_amount": null,
    "payment_method": "cash",
    "payment_status": "pending",
    "driver": {
      "id": 45,
      "first_name": "Kofi",
      "last_name": "Mensah",
      "phone": "+22899876543",
      "profile_image": "https://...",
      "rating": 4.9,
      "vehicle": {
        "make": "Toyota",
        "model": "Corolla",
        "color": "Silver",
        "plate_number": "TG 1234 AB"
      },
      "location": {
        "latitude": 6.1350,
        "longitude": 1.2250,
        "updated_at": "2024-01-20T16:32:00Z"
      }
    },
    "timeline": [
      {"status": "pending", "time": "2024-01-20T16:30:00Z"},
      {"status": "accepted", "time": "2024-01-20T16:31:00Z"}
    ],
    "created_at": "2024-01-20T16:30:00Z"
  }
}
```

### PUT /booking/:id/cancel

Annuler une reservation.

**Request:**

```json
{
  "reason": "Changed plans"
}
```

**Response (200):**

```json
{
  "data": {
    "id": 123,
    "booking_status": "cancelled",
    "cancellation_fee": 500,
    "cancelled_at": "2024-01-20T16:35:00Z"
  }
}
```

### POST /booking/:id/rate

Noter une course.

**Request:**

```json
{
  "rating": 5,
  "comment": "Excellent service!",
  "tip_amount": 500
}
```

### GET /booking/history

Historique des reservations.

**Query Parameters:**

| Param | Type | Description |
|-------|------|-------------|
| page | int | Page (default: 1) |
| limit | int | Limite (default: 20) |
| status | string | Filtrer par status |
| from | date | Date debut |
| to | date | Date fin |

**Response (200):**

```json
{
  "data": [
    {
      "id": 123,
      "booking_number": "BK-2024-00123",
      "booking_status": "completed",
      "pickup_address": "123 Rue de Lome",
      "drop_address": "456 Avenue Liberation",
      "final_amount": 3200,
      "driver": {
        "first_name": "Kofi",
        "rating": 4.9
      },
      "completed_at": "2024-01-20T17:00:00Z"
    }
  ],
  "meta": {
    "total": 42,
    "page": 1,
    "limit": 20,
    "totalPages": 3
  }
}
```

---

## Driver

### POST /driver/signup

Inscription chauffeur.

**Request:**

```json
{
  "first_name": "Kofi",
  "last_name": "Mensah",
  "email": "kofi@example.com",
  "phone": "+22899876543",
  "country_code": "+228",
  "password": "SecurePass123!",
  "vehicle_type_id": 1
}
```

### PUT /driver/location

Mettre a jour la position.

**Request:**

```json
{
  "latitude": 6.1350,
  "longitude": 1.2250,
  "heading": 45,
  "speed": 35
}
```

### PUT /driver/status

Changer le statut (online/offline).

**Request:**

```json
{
  "is_online": true
}
```

### GET /driver/earnings

Obtenir les gains.

**Query Parameters:**

| Param | Type | Description |
|-------|------|-------------|
| period | string | today, week, month, year |
| from | date | Date debut |
| to | date | Date fin |

**Response (200):**

```json
{
  "data": {
    "total_earnings": 150000,
    "total_trips": 45,
    "total_distance": 320.5,
    "total_hours": 38,
    "commission_paid": 30000,
    "net_earnings": 120000,
    "currency": "XOF",
    "breakdown": [
      {"date": "2024-01-20", "earnings": 12000, "trips": 5},
      {"date": "2024-01-19", "earnings": 15000, "trips": 6}
    ]
  }
}
```

### PUT /driver/booking/:id/accept

Accepter une course.

### PUT /driver/booking/:id/arrived

Signaler l'arrivee.

### PUT /driver/booking/:id/start

Demarrer la course.

### PUT /driver/booking/:id/complete

Terminer la course.

**Request:**

```json
{
  "final_amount": 3200,
  "travel_distance": 8.7,
  "travel_time": 28
}
```

---

## Payment

### GET /payment/methods

Lister les moyens de paiement.

**Response (200):**

```json
{
  "data": [
    {
      "id": 1,
      "type": "card",
      "brand": "visa",
      "last4": "4242",
      "exp_month": 12,
      "exp_year": 2025,
      "is_default": true
    },
    {
      "id": 2,
      "type": "mobile_money",
      "provider": "mtn",
      "phone": "+22890***456",
      "is_default": false
    }
  ]
}
```

### POST /payment/methods

Ajouter un moyen de paiement.

**Request (carte):**

```json
{
  "type": "card",
  "stripe_token": "tok_xxx"
}
```

**Request (mobile money):**

```json
{
  "type": "mobile_money",
  "provider": "mtn",
  "phone": "+22890123456"
}
```

### DELETE /payment/methods/:id

Supprimer un moyen de paiement.

### POST /payment/charge

Effectuer un paiement.

**Request:**

```json
{
  "booking_id": 123,
  "payment_method_id": 1,
  "amount": 3200
}
```

---

## Promo

### POST /promo/validate

Valider un code promo.

**Request:**

```json
{
  "code": "WELCOME10",
  "amount": 3500
}
```

**Response (200):**

```json
{
  "data": {
    "valid": true,
    "code": "WELCOME10",
    "type": "percentage",
    "discount_value": 10,
    "discount_amount": 350,
    "final_amount": 3150
  }
}
```

---

## Delivery

### POST /delivery/estimate

Estimer une livraison.

**Request:**

```json
{
  "pickup": {
    "latitude": 6.1319,
    "longitude": 1.2228,
    "address": "123 Rue de Lome",
    "contact_name": "Sender",
    "contact_phone": "+22890123456"
  },
  "drops": [
    {
      "latitude": 6.1725,
      "longitude": 1.2314,
      "address": "456 Avenue Liberation",
      "contact_name": "Receiver 1",
      "contact_phone": "+22891234567"
    }
  ],
  "package_type": "small",
  "is_fragile": false
}
```

### POST /delivery/create

Creer une livraison.

### GET /delivery/:id/track

Suivre une livraison.

---

## Vehicle Types

### GET /vehicle-types

Lister les types de vehicules.

**Response (200):**

```json
{
  "data": [
    {
      "id": 1,
      "name": "Standard",
      "description": "Voiture economique",
      "icon": "https://...",
      "capacity": 4,
      "base_fare": 500,
      "per_km_fare": 150,
      "per_minute_fare": 25,
      "minimum_fare": 1000
    },
    {
      "id": 2,
      "name": "Comfort",
      "description": "Voiture confortable",
      "icon": "https://...",
      "capacity": 4,
      "base_fare": 800,
      "per_km_fare": 200,
      "per_minute_fare": 35,
      "minimum_fare": 1500
    }
  ]
}
```

---

## Zones

### GET /zones

Lister les zones de service.

**Response (200):**

```json
{
  "data": [
    {
      "id": 1,
      "name": "Lome Centre",
      "type": "service_area",
      "coordinates": [...],
      "is_active": true
    }
  ]
}
```

### GET /zones/check

Verifier si un point est dans une zone de service.

**Query Parameters:**

| Param | Type | Description |
|-------|------|-------------|
| lat | float | Latitude |
| lng | float | Longitude |

---

## WebSocket Events

### Connection

```javascript
const socket = io('wss://api.monkapi.com/booking', {
  auth: { token: 'Bearer xxx' }
});
```

### Events Client -> Server

| Event | Payload | Description |
|-------|---------|-------------|
| `track` | `{ booking_id }` | Suivre une reservation |
| `untrack` | `{ booking_id }` | Arreter le suivi |

### Events Server -> Client

| Event | Payload | Description |
|-------|---------|-------------|
| `booking:status` | `{ status, ... }` | Changement de statut |
| `driver:location` | `{ lat, lng, heading }` | Position chauffeur |
| `driver:assigned` | `{ driver }` | Chauffeur assigne |
| `booking:completed` | `{ booking }` | Course terminee |

---

## Codes d'erreur

| Code | Description |
|------|-------------|
| `AUTH_INVALID_CREDENTIALS` | Identifiants invalides |
| `AUTH_TOKEN_EXPIRED` | Token expire |
| `AUTH_OTP_INVALID` | OTP invalide |
| `USER_NOT_FOUND` | Utilisateur non trouve |
| `DRIVER_NOT_FOUND` | Chauffeur non trouve |
| `BOOKING_NOT_FOUND` | Reservation non trouvee |
| `BOOKING_INVALID_STATUS` | Transition de statut invalide |
| `BOOKING_ALREADY_CANCELLED` | Deja annulee |
| `PAYMENT_FAILED` | Paiement echoue |
| `PAYMENT_INSUFFICIENT_FUNDS` | Solde insuffisant |
| `PROMO_INVALID` | Code promo invalide |
| `PROMO_EXPIRED` | Code promo expire |
| `ZONE_NOT_SERVICED` | Zone non desservie |

---

## Rate Limiting

| Endpoint | Limite |
|----------|--------|
| `/auth/*` | 10 req/min |
| `/booking/create` | 5 req/min |
| `/payment/*` | 10 req/min |
| Autres | 100 req/min |

Reponse si limite atteinte:

```json
{
  "statusCode": 429,
  "message": "Too Many Requests",
  "retryAfter": 60
}
```
